<?php
class AcelleWPWorkflowsContactForm7
{
    public function __construct()
    {
        add_filter('acellemail_wp_customize_trigger', array($this, 'addContactForm7Trigger'));
        add_action('acellemail_wp_custom_trigger', array($this, 'submit_trigger'));

    }

    public function addContactForm7Trigger($triggers)
    {

        $args             = array('post_type' => 'wpcf7_contact_form', 'posts_per_page' => -1);
        $cf7Forms         = get_posts($args);
        $contactFormArray = [];
        if ($cf7Forms) {
            foreach ($cf7Forms as $forms) {
                $contactFormArray = [
                    ['key' => $forms->ID, 'value' => $forms->post_title],
                ];
            }
        }
        $triggers[] = [
            'title'                    => __('Contact Form 7 Submitted', 'CAI'),
            'trigger_slug'             => 'trigger_contact_form_7_submitted',
            'no_option'                => false,
            'option_display_name'      => __('Contact Forms', 'CAI'),
            'option_default_value'     => '',
            'trigger_ui_type'          => 'select',
            'trigger_available_option' => $contactFormArray,
        ];
        return $triggers;
    }

    public function triggerContactform7Submitted($rule)
    {
        $this->rules = $rule;
        $self        = $this;
        add_action('wpcf7_before_send_mail', function ($contact_form) use ($self) {

            $this->onSubmitContactForm($contact_form, $this->rules);
        });

    }

    public function onSubmitContactForm($cf7, $rule)
    {
        if (class_exists('WPCF7_Submission')) {
            $submission = WPCF7_Submission::get_instance();
            if ($submission) {
                $subscriber  = [];
                $posted_data = $submission->get_posted_data();
                if ($cf7->id() == $rule['trigger_option'][0]) {
                    if ($posted_data) {
                        foreach ($posted_data as $key => $data) {
                            if (preg_match('/email/i', $key)) {
                                $subscriber['EMAIL'] = $data;
                            }
                            if (preg_match('/your-name/i', $key)) {
                                $subscriber['FIRST_NAME'] = $data;
                            }
                            if (preg_match('/first_name/i', $key)) {
                                $subscriber['FIRST_NAME'] = $data;
                            }
                            if (preg_match('/last_name/i', $key)) {
                                $subscriber['LAST_NAME'] = $data;
                            }
                        }
                    }
                }
                if ($subscriber) {
                    $objSync = new AcelleWPWorkflowsSync();
                    $objSync->perform_action($rule['action'], $rule['action_option'][0], $subscriber);
                }

            }
        }

    }

    public function submit_trigger($rules)
    {
        if ($rules) {
            foreach ($rules as $key => $rule) {
                if ($rule['trigger'] == 'trigger_contact_form_7_submitted') {
                    $this->triggerContactform7Submitted($rule);
                }

            }
        }

    }

}
